var d = new Date();
console.log(d.toString());
console.log(d.toUTCString());
console.log(d.toDateString());

var dataJSON;
var listCount = 0;
loadJSONData(true, true);

var listHTML = 
"<li id=\"li_X\">" +
"  <input type=\"radio\" name=\"radio\" value=\"X\" id=\"li_radio_X\" onclick=\"listClicked(this);\">" +
"    <i></i>" +
"    <label for=\"li_radio_X\" class=\"sizeH2\">Z</label>" +
"  </input>" +
"  <span>" +
"    <span class=\"slideThree\" style=\"position:absolute; display: block; margin:0px; right:10px; top:12px;\">" +
"      <input type=\"checkbox\" value=\"yo\" id=\"slide_X\" name=\"slide_X\" onchange=\"slideChanged(this);\" />" +
"      <label for=\"slide_X\"></label>" +
"    </span>" +
"  </span>" +
"  <div class=\"entryDiv\" id=\"settings_X\">" +
"  </div>" +
"</li>";



var settingsModified = false;
var checkedListID;

//var allTheDays = document.getElementById("repeat_options").getElementsByTagName("input");

//var timeWarpClockTime = document.getElementById("timeWarpClockTime");
var timeWarpSysTime = document.getElementById("timeWarpSysTime");

var socket = io();

socket.on('Client System Time Request', function()
{
  syncSysTime();
/*var playerData = data.playerData;
var ballPos = data.ballPos;
var ballVisible = data.ballVisible;
var state = data.state;*/
});

socket.on('clock update',  function(data)
{
//  var clockFaceHour = data.hour;
//  var clockFaceMinute = data.minute;
//  var clockFaceSeconds = data.second;
   
  var hours = data.hour;// + Math.floor(new Date().getTimezoneOffset() / 60);  //new Date().getHours();
  var mins = data.minute;// + (new Date().getTimezoneOffset() % 60); //new Date().getMinutes();
  var seconds = data.second;  //new Date().getSeconds();
  
  var hdegree = hours * 30 + (mins / 2);
  var hrotate = "rotate(" + hdegree + "deg)";
  
  var mdegree = mins * 6;
  var mrotate = "rotate(" + mdegree + "deg)";
  
  var sdegree = seconds * 6;
  var srotate = "rotate(" + sdegree + "deg)";
  
  $("#hour").css({"-moz-transform" : hrotate, "-webkit-transform" : hrotate});
  $("#min").css({"-moz-transform" : mrotate, "-webkit-transform" : mrotate});
  $("#sec").css({"-moz-transform" : srotate, "-webkit-transform" : srotate});
 
  //timeWarpClockTime.innerHTML = (data.hour + ":" + data.minute + ":" + data.second);
  var serverTime = new Date(data.sysTime);// + (new Date().getTimezoneOffset() * 60000));
  timeWarpSysTime.innerHTML = "Server Date: " + serverTime.toString();
 
  //console.log(clockFaceHour + ":" + clockFaceMinute + ":" + clockFaceSeconds);
});

socket.on('reload active',  function()
{
  // load new values for settings' active value
  loadJSONData(true, false);
});

  //socket.emit('connection request');
//socket.disconnect();

function loadListElements(listItemValue)
{
  var listItemNo = parseInt(listItemValue) - 1;
  var modifySetting = false;                            // Is any field blank which shouldn't be? Don't let the user get away with it. XD
  var backup_settingsModified = settingsModified;       //changeAction() which we use to hide/show fields also sets settingsModified to true. So this is a backup
  
  if(listItemValue == "new")    // if it is a new list element 
  {
    // Add a last empty array object added to dataJSON so all fields come up blank
    dataJSON.Settings.push("{}");
    listItemNo = listCount;
  }
  
  if(!isNaN(listItemNo))
  {
    console.log(JSON.stringify(dataJSON.Settings[listItemNo]));
    
    var timeWarp_speed_select = document.getElementById("timeWarp_speed_select");
    if(dataJSON.Settings[listItemNo].hasOwnProperty("timeWarp_speed_select"))
    {
      timeWarp_speed_select.value = dataJSON.Settings[listItemNo].timeWarp_speed_select;
      changeAction(timeWarp_speed_select);
    }
    else
    {
      timeWarp_speed_select.value = "1";
      console.log("timeWarp_speed_select undefined!");
      modifySetting = true;
      changeAction(timeWarp_speed_select);
    }    
    
    var timeWarp_start_select = document.getElementById("timeWarp_start_select");    
    if(dataJSON.Settings[listItemNo].hasOwnProperty("timeWarp_start_select"))
    {
      timeWarp_start_select.value = dataJSON.Settings[listItemNo].timeWarp_start_select;
      //toggleText(timeWarp_start_select);
      changeAction(timeWarp_start_select);
      
      if(dataJSON.Settings[listItemNo].hasOwnProperty("timeWarp_start_input"))
        document.getElementById("timeWarp_start_input").value = dataJSON.Settings[listItemNo].timeWarp_start_input;
      else
      {
        document.getElementById("timeWarp_start_input").value = "";
        console.log("timeWarp_start_input undefined!");
        modifySetting = true;
      }
    }
    else
    {
      timeWarp_start_select.value = "1";
      console.log("timeWarp_start_select undefined!");
      modifySetting = true;
      changeAction(timeWarp_start_select);
      
      document.getElementById("timeWarp_start_input").value = "";
    }
    
    var timeWarp_end_select = document.getElementById("timeWarp_end_select");
    if(dataJSON.Settings[listItemNo].hasOwnProperty("timeWarp_end_select"))
    {
      timeWarp_end_select.value = dataJSON.Settings[listItemNo].timeWarp_end_select;
      //toggleText(timeWarp_end_select);
      changeAction(timeWarp_end_select);
      
      if(dataJSON.Settings[listItemNo].hasOwnProperty("timeWarp_end_input"))
        document.getElementById("timeWarp_end_input").value = dataJSON.Settings[listItemNo].timeWarp_end_input;
      else
      {
        document.getElementById("timeWarp_end_input").value = "";
        console.log("timeWarp_end_input undefined!");
        modifySetting = true;
      }
    }
    else
    {
      timeWarp_end_select.value = "1";
      changeAction(timeWarp_end_select);
      
      document.getElementById("timeWarp_end_input").value = "";
      console.log("timeWarp_end_input undefined!");
      modifySetting = true;
    }
    
    
    var repeat_check = document.getElementById("repeat_check");
    if(dataJSON.Settings[listItemNo].hasOwnProperty("repeat_check"))
    {
      repeat_check.checked = true;
      changeAction(repeat_check);
      
      var allTheDays = document.getElementById("repeat_options").getElementsByTagName("input");
      for(i = 0; i < allTheDays.length; i++)
      {
        if(dataJSON.Settings[listItemNo].hasOwnProperty(allTheDays[i].name))
          allTheDays[i].checked = true;
        else
          allTheDays[i].checked = false;
      }
      
      //hideRow(true, 'repeat_options');
    }
    else
    {
      console.log("Setting repeat_Scheck to false");
      repeat_check.checked = false;
      console.log("Calling changeAction with checked: " + repeat_check.checked);
      changeAction(repeat_check);
      //hideRow(false, 'repeat_options');
      
      // if Repeat? isn't checked, set all the day options to selected by default
      var allTheDays = document.getElementById("repeat_options").getElementsByTagName("input");
      for(i = 0; i < allTheDays.length; i++)
        allTheDays[i].checked = true;
    }    
  }
  
  var timeWarp_change_select = document.getElementById("timeWarp_change_select");
  if(dataJSON.Settings[listItemNo].hasOwnProperty("timeWarp_change_select"))
  {
    timeWarp_change_select.value = dataJSON.Settings[listItemNo].timeWarp_change_select;
    //byChanged(timeWarp_change_select);
    changeAction(timeWarp_change_select);
    
    if(dataJSON.Settings[listItemNo].hasOwnProperty("timeWarp_change_input"))
      document.getElementById("timeWarp_change_input").value = dataJSON.Settings[listItemNo].timeWarp_change_input;
    else
    {
      document.getElementById("timeWarp_change_input").value = "";
      console.log("timeWarp_change_input undefined!");
      modifySetting = true;
    }
  }
  else            // Is this valid???
  {
    timeWarp_change_select.value = "1";
    changeAction(timeWarp_change_select);
    document.getElementById("timeWarp_change_input").value = "";
  }
  
  // If it was a temp new list item, remove the last empty array object added to dataJSON
  if(listItemNo == listCount)
    dataJSON.Settings.pop();
    
  if(modifySetting)
    settingsModified = true;
  else
    settingsModified = backup_settingsModified;
}

function escapeRegExp(string) {
    return string.replace(/([.*+?^=!:${}()|\[\]\/\\])/g, "\\$1");
}

function replaceAll(string, find, replace)
{
  return string.replace(new RegExp(escapeRegExp(find), 'g'), replace);
}

function byChanged(selectObj)
{
  //console.log(selectObj.value);
  if(selectObj.value == "1")
    document.getElementById('timeWarp_change_input').type = "time";
  else
    document.getElementById('timeWarp_change_input').type = "number";
}

function hideRow(hide, rowID)
{
//console.log("Hidden: " + hide + " " + rowID);
  var x = document.getElementById(rowID);
  var y = x.getElementsByTagName("select");
  var z = x.getElementsByTagName("input");
  
  //var xIncluded = (x.tagName == "input" || x.tagName == "select") ? true : false;
  
  if(hide)
  {
    //x.style.margin = "0px";
    x.style.maxHeight = "0px";
    x.style.opacity = "0";
    
    for(i = 0; i < y.length; i++)
    {
      console.log("disabling: " + y[i].id);
      y[i].disabled = true;
      //y[i].setAttribute('disabled', true);
    }
    
    for(i = 0; i < z.length; i++)
    {
      console.log("disabling: " + z[i].id);
      z[i].disabled = true;
    }
  }
  else
  {
    x.style.maxHeight = "800px";
    x.style.opacity = "1";
    
    for(i = 0; i < y.length; i++)
    {
      console.log("enabling: " + y[i].id);
      y[i].disabled = false;
      //y[i].removeAttribute('disabled');
    }
    
    for(i = 0; i < z.length; i++)
    {
      console.log("enabling: " + z[i].id);
      z[i].disabled = false;
      //z[i].value = "";
    }
  }
}

function showHoursText(selectObj, show)
{
  var parentObj = selectObj.parentNode.parentNode;
  //var textObj = parentObj.getElementsByName("text");
  var childrenObj = parentObj.children;
  //console.log(childrenObj.length);
  
  for(i = 0; i < childrenObj.length; i++)
  {
    if(childrenObj[i].getAttribute("name") == "text")
    {
      if(show)
      {
        childrenObj[i].style.maxWidth = "800px";
        childrenObj[i].style.opacity = "1";
      }
      else
      {
        childrenObj[i].style.maxWidth = "0px";
        childrenObj[i].style.opacity = "0";
      }
      break;
    }
  }
}

function getFormattedDate(dateInput)
{
  //11:52:10 - Sat - 19 Sep
  
  var days = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
  var months = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
  var result = "";
  if(dateInput.getHours() < 10)
    result += "0";
  result += dateInput.getHours() + ":";
  
  if(dateInput.getMinutes() < 10)
    result += "0";
  result += dateInput.getMinutes() + ":";

  if(dateInput.getSeconds() < 10)
    result += "0";
  result += dateInput.getSeconds() + " - ";

  result += days[dateInput.getDay()] + " - ";
  
  result += dateInput.getDate() + " " + months[dateInput.getMonth()];
  
  return result;
}

function changeAction(changedElement)
{
  settingsModified = true;
  
  switch(changedElement.id)
  {
    case "timeWarp_speed_select":
      if(changedElement.value == "3" || changedElement.value == "4")
        hideRow(true, "timeWarp_line3");
      else
        hideRow(false, "timeWarp_line3");
      break;
    
    case "timeWarp_start_select":
      if(changedElement.value == "1")
      {
        //document.getElementById("repeat_check").checked = false;
        hideRow(false, "repeat_check_div");
        changeAction(document.getElementById("repeat_check"));
        //hideRow(true, "repeat_options");
        showHoursText(changedElement, false);
      }
      else if(changedElement.value == "2")
      {
        hideRow(true, "repeat_check_div");
        hideRow(true, "repeat_options");
        showHoursText(changedElement, true);
      }
      break;
    case "timeWarp_start_input":
      break;
      
    case "timeWarp_end_select":
      if(changedElement.value == "1")
        showHoursText(changedElement, false);
      else if(changedElement.value == "2")
        showHoursText(changedElement, true);
      break;
    case "timeWarp_end_input":
      break;
    
    case "timeWarp_change_select":
      byChanged(changedElement);
      break;
    case "timeWarp_change_input":
      break;
      
    case "repeat_check":
      if(changedElement.checked && getSelectedDaysCount() == 0)
      {
        var allTheDays = document.getElementById("repeat_options").getElementsByTagName("input");
        for(i = 0; i < allTheDays.length; i++)
          allTheDays[i].checked = true;
      }
      hideRow(!changedElement.checked, 'repeat_options');
      break;
    case "repeat_check_Mon":
    case "repeat_check_Tue":
    case "repeat_check_Wed":
    case "repeat_check_Thu":
    case "repeat_check_Fri":
    case "repeat_check_Sat":
    case "repeat_check_Sun":
      if(getSelectedDaysCount() == 0)
      {
        document.getElementById("repeat_check").checked = false;
        hideRow(true, 'repeat_options');
      }
      break;
  }
}

function listClicked(clickedItem)               // returns true if the clicked list element was opened. If user refused to discard changes, returns false
{  
  if(checkedListID != null)                     // a list item was previously open
  {
    var prevOpenListElement = document.getElementById(checkedListID);

    if(settingsModified)                        // if something was changed
    {
      prevOpenListElement.checked = true;       // keep the previously open list element open for now
      if(confirm("Discard changes?"))           // clicked on OK(i.e. discarding changes)
      {
        //console.log("discarded");
        document.getElementById(checkedListID).checked = false;
        
        if(checkedListID == "li_radio_new")  // if the temp new unsaved list element was open
        {
          // transfer form to formHolder
          document.getElementById("formHolder").appendChild(document.getElementById("editForm"));

          // delete the temp new list element
          document.getElementById("listContainer").removeChild(document.getElementById("li_new"));
          console.log("removing the new node");
          
          //deleteClicked(document.getElementById(checkedListID));
        }
        
        if(checkedListID == clickedItem.id)     // clicked on opened list item again. Will end up closing it.
        {
          //console.log("Closing list item");
          checkedListID = null;
          settingsModified = false;
          
          return true;
        }
        else                                  // another list element was clicked
        {          
          clickedItem.checked = true;          
        }
      }
      else                                  // clicked on CANCEL(i.e. NOT discarding changes)
      {
        //console.log("not discarded");
        
        //clickedItem.checked = false;
        
        //document.getElementById(checkedListID).checked = true;
        
        return false;
      }
    }
    else                                    // if no changes were made
    {
      if(checkedListID == clickedItem.id)   // closing the opened list item
      {
        //console.log("Closing list item");
        clickedItem.checked = false;
        checkedListID = null;
        //settingsModified = false;
        return true;
      }
    }
  }
    
  console.log("changing parent to " + clickedItem.id);

  clickedItem.checked = true;
  
  // Add the form to the newly opened list element
  var settingsDiv = document.getElementById("settings_" + clickedItem.value);
  console.log("Adding form to " + settingsDiv.id);
  settingsDiv.appendChild(document.getElementById('editForm'));
  
  checkedListID = clickedItem.id;
  settingsModified = false;

  // Enable the list elements if slider is OFF, BEFORE loadListElements disables specific elements
  var slideChecked = document.getElementById("slide_" + clickedItem.value).checked;
  if(!slideChecked)
    disableSettings(slideChecked, clickedItem.value);
    
  // Load the input and selects value from JSON data
  loadListElements(clickedItem.value);  
  console.log("settingsModified : " + settingsModified);
  
  // Disable the list elements if slider is ON, AFTER loadListElements enables specific elements
  if(slideChecked)
    disableSettings(slideChecked, clickedItem.value);
  
  return true;
}

function saveClicked(saveButtObj)
{
  // Validate
  if(document.getElementById("timeWarp_start_input").value == "")
  {
    alert("Enter a value for start time");
    return false;
  }
  
  if(document.getElementById("timeWarp_end_input").value == "")
  {
    alert("Enter a value for end time");
    return false;
  }
  
  if(document.getElementById("timeWarp_line3").style.opacity == "1" && document.getElementById("timeWarp_change_input").value == "")
  {
    alert("Enter a value for time warp change amount");
    return false;
  }
  
  // Get the ID of setting
  var settings_X = document.getElementById("editForm").parentNode.id.split("_");
  var X = settings_X[settings_X.length - 1];
  console.log("Saving " + X);
  
  document.getElementById('load').style.visibility="visible";
  
  // Save the list element using AJAX
  var form = $('#editForm');
  var formJSONSerialized = form.serializeArray();
  console.log(formJSONSerialized);
  if(document.getElementById("slide_" + X).checked)
    formJSONSerialized.push({name: 'active', value: "yo"});
  else
    formJSONSerialized.push({name: 'active', value: "no"});
  console.log(JSON.stringify(formJSONSerialized));
  
/*  var formJSONParsed = JSON.parse(formJSONSerialized);
  formJSONParsed.ID = X;
  console.log(JSON.stringify(formJSONParsed));*/
  
  var response = $.ajax(
  {
    url : "/save_" + X,     //$(this).attr('action'), // || window.location.pathname,
    type: "POST",
    data: formJSONSerialized, //form.serialize(),
    async: false
  }).responseText;
  
  document.getElementById('load').style.visibility="hidden";
  
  console.log(response);
  
  if(response == "Success!")
  {
    loadJSONData(false, true);

    //settingsModified = false;
    
    // open again the previously open list element
    if(X == "new")
    {
      console.log("li_radio_" + listCount.toString());
      console.log(listCount);
      listClicked(document.getElementById("li_radio_" + listCount.toString()));     // open the last list element, i.e. the newly added one
    }
    else
      listClicked(document.getElementById("li_radio_" + X));                        // re-open the list item we saved
    
    return true;
  }
  else
    alert("Sorry, could not save :(");
}

function deleteClicked(deleteButtObj)
{
  // Get the ID of setting
  var settings_X = document.getElementById("editForm").parentNode.id.split("_");
  var X = settings_X[settings_X.length - 1];
  console.log("Deleting " + X);
  
  var response;
  
  if(X == "new")            // if we are deleting a new unsaved list element
  {
    // transfer form to formHolder
    document.getElementById("formHolder").appendChild(document.getElementById("editForm"));

    // delete the temp new list element
    document.getElementById("listContainer").removeChild(document.getElementById("li_new"));
    console.log("removing the new node");
    
    checkedListID = null;
    settingsModified = false;

    //response = "Success!";  // no need for AJAX. Just delete straight away.
  }
  else
  {
    document.getElementById('load').style.visibility = "visible";
    
    // Remove the list element using AJAX
    //var form = $('#editForm');
    var response = $.ajax(
    {
      url : "/delete_" + X,     //$(this).attr('action'), // || window.location.pathname,
      type: "POST",
      //data: X,
      async: false
    }).responseText;
    
    document.getElementById('load').style.visibility="hidden";
    
    console.log(response);
  }
  
  if(response == "Success!")
  {
    loadJSONData(false, true);
    
    // transfer form to formHolder
    //document.getElementById("formHolder").appendChild(document.getElementById("editForm"));

    // delete the temp new list element
    //document.getElementById("listContainer").removeChild(document.getElementById("li_" + X));
    //console.log("removing the new node");
  }
}

function addClicked()
{
  console.log("Adding new entry");
  
  //var newListHolder = document.getElementById("newListHolder");
  //newListHolder.innerHTML = replaceAll(listHTML, "X", "new");;
  
  var newListElement = document.getElementById("li_radio_new");
  if(newListElement != null)        // does a newly added but unsaved list element exist?
  {
    if(!listClicked(newListElement))    // Try to close it. If the changes weren't discarded:
      return false;                 // Do not add new list element
  }
  else                              // no new list element exists
  {
    // search and close any open list element
    for(i = 1; i <= listCount; i++)
    {
      var listElement = document.getElementById("li_radio_" + i.toString());
      if(listElement.checked)
      {
        if(listClicked(listElement))
          break;
        else
          return false;
      }
    }    
  }

  //alert("starting innerHTML add");
  // Add a new temporary list element
  var listContainer = document.getElementById("listContainer");
  listContainer.innerHTML += replaceAll(replaceAll(listHTML, "X", "new"), "Z", "New");
  //listContainer.appendChild(document.getElementById("li_radio_new"));
  
  console.log(checkedListID);
  checkedListID = null;
  listClicked(document.getElementById("li_radio_new"));
  settingsModified = true;
  
  // set active slider for all settings
  for(i = 0; i < listCount; i++)
  {
    console.log(dataJSON.Settings[i].active);
    if(dataJSON.Settings[i].active == "yo")
      document.getElementById("slide_" + (i+1).toString()).checked = true;
    else
      document.getElementById("slide_" + (i+1).toString()).checked = false;
  }
  
  //setTimeout(function(){listClicked(document.getElementById("li_radio_new")); console.log("new list clicked");}, 5000);
  
  return true;
}

function getSelectedDaysCount()
{
  var allTheDays = document.getElementById("repeat_options").getElementsByTagName("input");
  var count = 0;
  for(i = 0; i < allTheDays.length; i++)
    if(allTheDays[i].checked)
      count++;
  
  console.log(count);
  return count;
}

function loadJSONData(doAsync, changeHTML)
{
  // transfer form to formHolder
  document.getElementById("formHolder").appendChild(document.getElementById("editForm"));

  if(!doAsync)
  {
    document.getElementById('load').style.visibility="visible";
  }
  
  $.ajax({
    url: "/settings.json",
    dataType: "json",
    async: doAsync,
    success: function(response)
    {
      /*$.each(response.Users, function(item)
      {
        console.log(JSON.stringify(item));
        //informationArray.push(item);
      });
      //informationArray.push("success");*/
      dataJSON = response;
      
      if(changeHTML)
      {
        var listContainer = document.getElementById("listContainer");
        listContainer.innerHTML = "";
        listCount = dataJSON.Settings.length;
        for(i = 0; i < listCount; i++)
        {
          listContainer.innerHTML += replaceAll(replaceAll(listHTML, "X", (i+1).toString()), "Z", dataJSON.Settings[i].title);
        }
      }
      
      for(i = 0; i < listCount; i++)
      {
        console.log(dataJSON.Settings[i].active);
        if(dataJSON.Settings[i].active == "yo")
          document.getElementById("slide_" + (i+1).toString()).checked = true;
        else
          document.getElementById("slide_" + (i+1).toString()).checked = false;
      }
    }
  });
  
  if(!doAsync)
  {
    document.getElementById('load').style.visibility="hidden";
  }
  
  checkedListID = null;
  settingsModified = false;
}

function slideChanged(slideObj)
{
  var slideSuccessful = true;

  var slide_X = slideObj.id.split("_");
  var X = slide_X[slide_X.length - 1];
  console.log("Slider changed: " + X);
  
  var isOpen = document.getElementById("li_radio_" + X).checked;
  
  if(isOpen && slideObj.checked)        // if the list element we're turning ON is open
  {
    if(settingsModified)                                      // if something was changed
    {
      alert("There are unsaved changes. Please save or discard them before turning ON.");
      slideSuccessful = false;
    }
  }
  
  if(slideSuccessful)
  {
    document.getElementById('load').style.visibility = "visible";
    
    var activeVal;
    if(slideObj.checked)
      activeVal = "yo";
    else
      activeVal = "no";
      
      var stuff = {"active": activeVal};

    // Activate/deactivate the list element using AJAX
    //var form = $('#editForm');
    var response = $.ajax(
    {
      url : "/active_" + X,     //$(this).attr('action'), // || window.location.pathname,
      type: "POST",
      data: stuff,
      async: false
    }).responseText;
    
    document.getElementById('load').style.visibility="hidden";
    
    console.log(response);
    
    if(response != "Success!")
    {
      slideSuccessful = false;
      alert("Sorry, cannot turn setting ON/OFF" + ".\n" + response);
    }
  }
  
  if(slideSuccessful)
  {
    if(isOpen)
      disableSettings(slideObj.checked, X);
  }
  else
    slideObj.checked = !slideObj.checked;
}

function disableSettings(disable, valX)
{
  var x = document.getElementById("settings_" + valX);
  var y = x.getElementsByTagName("select");
  var z = x.getElementsByTagName("input");

  for(i = 0; i < y.length; i++)
    y[i].disabled = disable;
    
  for(i = 0; i < z.length; i++)
    z[i].disabled = disable;
}

function syncSysTime()
{
  var currTime = new Date();
  var stuff = {"sysTime": currTime, "timezone": currTime.getTimezoneOffset()};
  
  var response = $.ajax(
  {
    url : "/sync",
    type: "POST",
    data: stuff,
    async: false
  }).responseText;
  
  if(response == "Success!")
  {
    console.log("Time sync'd");
  }
  else
  {
    console.log("Sync failed :(");
  }  
}